/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.videolan.FontIndexData;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FontIndex
extends DefaultHandler
implements EntityResolver {
    private static final int ELEMENT_NONE = 0;
    private static final int ELEMENT_NAME = 1;
    private static final int ELEMENT_FORMAT = 2;
    private static final int ELEMENT_FILENAME = 3;
    private static final int ELEMENT_SIZE = 4;
    private static final int ELEMENT_STYLE = 5;
    private boolean inDocument = false;
    private int element = 0;
    private FontIndexData fontData = null;
    private ArrayList fontDatas = new ArrayList();

    public static FontIndexData[] parseIndex(String path) {
        return new FontIndex(path).getFontIndexData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontIndex(String path) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(path);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)stream, (DefaultHandler)this);
        }
        catch (FileNotFoundException parser) {
        }
        catch (Exception e) {
            System.err.println("error parsing font index: " + e);
        }
        finally {
            this.fontData = null;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public FontIndexData[] getFontIndexData() {
        return this.fontDatas.toArray(new FontIndexData[this.fontDatas.size()]);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.contains("http://www.dvb.org/mhp/dtd/fontdirectory-1-0.dtd")) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("fontdirectory")) {
            this.inDocument = true;
            return;
        }
        if (this.inDocument) {
            if (qName.equalsIgnoreCase("font")) {
                this.fontData = new FontIndexData();
            } else if (qName.equalsIgnoreCase("name")) {
                this.element = 1;
            } else if (qName.equalsIgnoreCase("fontformat")) {
                this.element = 2;
            } else if (qName.equalsIgnoreCase("filename")) {
                this.element = 3;
            } else if (qName.equalsIgnoreCase("style")) {
                this.element = 5;
            } else if (qName.equalsIgnoreCase("size")) {
                this.element = 4;
            } else {
                throw new SAXException("element not supported");
            }
            if (this.element == 4) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attrName = attributes.getQName(i);
                    if (attrName.equals("min")) {
                        this.fontData.minSize = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    if (attrName.equals("max")) {
                        this.fontData.maxSize = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    throw new SAXException("invalid attribute name: " + attrName);
                }
            } else if (attributes.getLength() != 0) {
                throw new SAXException("invalid attribute for state");
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("fontdirectory")) {
            this.inDocument = false;
            return;
        }
        if (this.inDocument && qName.equalsIgnoreCase("font")) {
            this.fontDatas.add(this.fontData);
            this.fontData = null;
        }
        this.element = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.element) {
            case 1: {
                this.fontData.name = new String(ch, start, length);
                break;
            }
            case 2: {
                this.fontData.format = new String(ch, start, length);
                break;
            }
            case 3: {
                this.fontData.filename = new String(ch, start, length);
                break;
            }
            case 5: {
                String style = new String(ch, start, length);
                if (style.equals("PLAIN")) {
                    this.fontData.style = 0;
                    break;
                }
                if (style.equals("BOLD")) {
                    this.fontData.style = 1;
                    break;
                }
                if (style.equals("ITALIC")) {
                    this.fontData.style = 2;
                    break;
                }
                if (style.equals("BOLD_ITALIC")) {
                    this.fontData.style = 3;
                    break;
                }
                throw new SAXException("invalid font style");
            }
        }
    }
}

