/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import org.blurayx.s3d.ui.HVideoConfigTemplateS3D;
import org.blurayx.uhd.ui.HVideoConfigurationTemplateUHD;
import org.havi.ui.HConfigurationException;
import org.havi.ui.HPermissionDeniedException;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.HScreenDevice;
import org.havi.ui.HVideoConfigTemplate;
import org.havi.ui.HVideoConfiguration;
import org.videolan.Logger;

public class HVideoDevice
extends HScreenDevice {
    public static final HVideoConfiguration NOT_CONTRIBUTING = null;
    private HVideoConfiguration[] hvcArray;
    private HVideoConfiguration hvc;

    protected HVideoDevice() {
        boolean is_p6 = this.isProfile6();
        boolean is_p5 = this.isProfile5();
        int length = HScreenConfigTemplate.defaultConfig.length;
        this.hvcArray = new HVideoConfiguration[length];
        for (int i = 0; i < length; ++i) {
            HVideoConfigTemplate hvct = is_p6 ? new HVideoConfigurationTemplateUHD() : (is_p5 ? new HVideoConfigTemplateS3D() : new HVideoConfigTemplate());
            HScreenConfigTemplate.initDefaultConfigTemplate(hvct, i);
            this.hvcArray[i] = new HVideoConfiguration(hvct);
        }
        this.hvc = this.hvcArray[0];
    }

    public HVideoConfiguration[] getConfigurations() {
        return this.hvcArray;
    }

    public HVideoConfiguration getDefaultConfiguration() {
        return this.hvcArray[0];
    }

    public HVideoConfiguration getBestConfiguration(HVideoConfigTemplate hvct) {
        int score = -1;
        HVideoConfiguration hvc = null;
        for (int i = 0; i < this.hvcArray.length; ++i) {
            if (hvct.match(this.hvcArray[i]) <= score) continue;
            hvc = this.hvcArray[i];
        }
        return hvc;
    }

    public HVideoConfiguration getBestConfiguration(HVideoConfigTemplate[] hvcta) {
        int score = -1;
        HVideoConfiguration hvc = null;
        for (int i = 0; i < this.hvcArray.length; ++i) {
            for (int j = 0; j < hvcta.length; ++j) {
                if (hvcta[j].match(this.hvcArray[i]) <= score) continue;
                hvc = this.hvcArray[i];
            }
        }
        return hvc;
    }

    public HVideoConfiguration getCurrentConfiguration() {
        return this.hvc;
    }

    public boolean setVideoConfiguration(HVideoConfiguration hvc) throws SecurityException, HPermissionDeniedException, HConfigurationException {
        this.hvc = hvc;
        return true;
    }

    public Object getVideoSource() throws SecurityException, HPermissionDeniedException {
        Logger.unimplemented(HVideoDevice.class.getName(), "getVideoSource");
        throw new HPermissionDeniedException();
    }

    public Object getVideoController() throws SecurityException, HPermissionDeniedException {
        Logger.unimplemented(HVideoDevice.class.getName(), "getVideoController");
        throw new HPermissionDeniedException();
    }
}

